	function [ZinNum, ZinDen] = ZIN_LADDER(Z, R_ZEROS, P)
	
	% 	Computes the input impedance (ZinNum/ZinDen) to a lowpass  
	%	LC ladder filter with finite zeros.
 
	% 	Toolbox for ANALOG FILTERS USING MATLAB
	
	%	Author: 		Lars Wanhammar 2007-08-26				
	%	Modified by: 	LW 2013-12-30, 2014-02-13
	%	Copyright:		by authors - not released for commercial use
	%	Version: 		1
	%	Known bugs:	 
	%	Report bugs to:	Wanhammar@gmail.com
	
	Rs = 1;
	PolyP = real(ROOTS_2_POLY(P));
	PolyRZ = real(ROOTS_2_POLY(R_ZEROS));
	ZinNum = Rs*POLYADD(PolyP, PolyRZ);
	ZinDen = POLYSUB(PolyP, PolyRZ);
	ZinDen(abs(ZinDen(1)) < 1000*eps) = []; % Normalize to highest power first
